/* $Id: server-GLogFunc.c,v 1.6 2005/12/17 05:19:13 lace Exp $
 * CORBA/ORBit server side of GLogFunc object, ran by sandbox_parent()
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "server-GLogFunc.h"	/* self */
#include "sandbox.h"
#include "split.h"
#include <glib/gmessages.h>
#include "captive/macros.h"
#include <libxml/tree.h>
#include "../client/vfs-parent.h"


static void impl_Captive_GLogFunc_g_log_func
		(impl_POA_Captive_GLogFunc *servant,const Captive_GLogMessage *g_log_message,CORBA_Environment *ev);

static PortableServer_ServantBase__epv impl_Captive_GLogFunc_base_epv={
	NULL,	/* _private data */
	NULL,	/* finalize routine */
	NULL,	/* default_POA routine */
	};
static POA_Captive_GLogFunc__epv impl_Captive_GLogFunc_epv={
	NULL,	/* _private */
	(gpointer)&impl_Captive_GLogFunc_g_log_func,
	};
static POA_Captive_GLogFunc__vepv impl_Captive_GLogFunc_vepv={
	&impl_Captive_GLogFunc_base_epv,
	&impl_Captive_GLogFunc_epv,
	};


Captive_GLogFunc impl_Captive_GLogFunc__create
		(PortableServer_POA poa,CaptiveVfsParentObject *captive_vfs_parent_object,CORBA_Environment *ev)
{
Captive_GLogFunc retval;
impl_POA_Captive_GLogFunc *newservant;
PortableServer_ObjectId *objid;

	captive_new0(newservant);	/* FIXME: leak */
	newservant->servant.vepv=&impl_Captive_GLogFunc_vepv;
	newservant->poa=poa;
	newservant->captive_vfs_parent_object=captive_vfs_parent_object;
	POA_Captive_GLogFunc__init((PortableServer_Servant)newservant,ev);
	objid=PortableServer_POA_activate_object(poa,newservant,ev);
	CORBA_free(objid);
	retval=PortableServer_POA_servant_to_reference(poa,newservant,ev);

	return retval;
}


void impl_Captive_GLogFunc__destroy(impl_POA_Captive_GLogFunc *servant,CORBA_Environment *ev)
{
PortableServer_ObjectId *objid;

	objid=PortableServer_POA_servant_to_id(servant->poa,servant,ev);
	PortableServer_POA_deactivate_object(servant->poa,objid,ev);
	CORBA_free(objid);
	POA_Captive_GLogFunc__fini((PortableServer_Servant)servant,ev);
	g_free(servant);
}


static void impl_Captive_GLogFunc_g_log_func
		(impl_POA_Captive_GLogFunc *servant,const Captive_GLogMessage *g_log_message,CORBA_Environment *ev)
{
GLogLevelFlags log_level_use;
static const struct level_map {
	GLogLevelFlags from,to;
	const gchar *name;
	} level_map[]={
		/* Downgrade always-fatal 'ERROR' to 'CRITICAL' level */
		{ G_LOG_LEVEL_ERROR   ,G_LOG_LEVEL_CRITICAL,"error"    },
		{ G_LOG_LEVEL_CRITICAL,G_LOG_LEVEL_CRITICAL,"critical" },
		{ G_LOG_LEVEL_WARNING ,G_LOG_LEVEL_WARNING ,"warning"  },
		{ G_LOG_LEVEL_MESSAGE ,G_LOG_LEVEL_MESSAGE ,"message"  },
		{ G_LOG_LEVEL_INFO    ,G_LOG_LEVEL_INFO    ,"info"     },
		{ G_LOG_LEVEL_DEBUG   ,G_LOG_LEVEL_DEBUG   ,"debug"    },
		};
static const struct flag_map {
	GLogLevelFlags from,to;
	const gchar *name;
	} flag_map[]={
		{ G_LOG_FLAG_RECURSION,G_LOG_FLAG_RECURSION,"recursion" },
		{ G_LOG_FLAG_FATAL    ,0                   ,"fatal"     },
		};
const struct level_map *levelp;
const struct flag_map *flagp;

	for (levelp=level_map;levelp<level_map+G_N_ELEMENTS(level_map);levelp++) {
		log_level_use=g_log_message->log_level;
		if (!(g_log_message->log_level & levelp->from))
			continue;
		{
		xmlNode *xml_message=NULL;

			if (servant->captive_vfs_parent_object->corba_bug_log) {
				xml_message=xmlNewTextChild(servant->captive_vfs_parent_object->corba_bug_log,NULL,BAD_CAST "message",BAD_CAST g_log_message->message);
					xmlNewProp(xml_message,BAD_CAST "level",BAD_CAST levelp->name);
				}

			log_level_use&=~levelp->from;
			log_level_use|= levelp->to;
			for (flagp=flag_map;flagp<flag_map+G_N_ELEMENTS(flag_map);flagp++) {
				if (!(g_log_message->log_level & flagp->from))
					continue;
				log_level_use&=~flagp->from;
				log_level_use|= flagp->to;
				if (xml_message)
					xmlNewProp(xml_message,BAD_CAST flagp->name,BAD_CAST flagp->name);
				}
			}
		g_log(G_LOG_DOMAIN,log_level_use,"sandbox: %s%s",
				(!(g_log_message->log_level & G_LOG_FLAG_FATAL) ? "" : "FATAL: "),
				g_log_message->message);
		}
}


static void impl_Captive_Vfs_init_g_log_func_log_func
		(const gchar *log_domain,GLogLevelFlags log_level,const gchar *message,const Captive_GLogFunc obj /* user_data */)
{
CORBA_Environment ev;
Captive_GLogMessage g_log_message;

	CORBA_exception_init(&ev);
	g_log_message.log_level=log_level;
	g_log_message.message=(CORBA_string)message;
	Captive_GLogFunc_g_log_func(obj,&g_log_message,&ev);
	g_assert(validate_CORBA_Environment(&ev));
	CORBA_exception_free(&ev);
}


static gboolean impl_Captive_Vfs_init_g_log_func_handled=FALSE;
static guint impl_Captive_Vfs_init_g_log_func_handler_id;
static Captive_GLogFunc g_log_func_copy;


/* We MUST NOT touch 'captive_options' as it may not be initialized yet
 */
void impl_Captive_Vfs_init_g_log_func(const Captive_GLogFunc g_log_func,gboolean debug_messages,CORBA_Environment *ev)
{
	g_assert(impl_Captive_Vfs_init_g_log_func_handled==FALSE);

	g_log_func_copy=CORBA_Object_duplicate(g_log_func,ev);
	if (ev->_major!=CORBA_NO_EXCEPTION)
		return;

	impl_Captive_Vfs_init_g_log_func_handler_id=g_log_set_handler(
			G_LOG_DOMAIN,	/* log_domain; "Captive" */
			0	/* log_levels */
					| 0	/* !G_LOG_FLAG_RECURSION */
					| G_LOG_FLAG_FATAL
					| (G_LOG_LEVEL_MASK & ~(debug_messages ? 0 : 0
							/* The same mask is in:
							 * libcaptive/sandbox/server-GLogFunc.c
							 * libcaptive/client/init.c
							 */
							| G_LOG_LEVEL_MESSAGE
							| G_LOG_LEVEL_INFO
							| G_LOG_LEVEL_DEBUG)),
			(GLogFunc)impl_Captive_Vfs_init_g_log_func_log_func,	/* log_func */
			(gpointer)g_log_func_copy);	/* user_data */

	impl_Captive_Vfs_init_g_log_func_handled=TRUE;
}


/* Called during child shutdown where our CORBA peer is no longer responding. */
void impl_Captive_Vfs_init_g_log_func_disable(void)
{
CORBA_Environment ev;

	if (!impl_Captive_Vfs_init_g_log_func_handled)
		return;

	g_log_remove_handler(
			G_LOG_DOMAIN,	/* log_domain; "Captive" */
			impl_Captive_Vfs_init_g_log_func_handler_id);	/* handler_id */
	CORBA_exception_init(&ev);
	CORBA_Object_release(g_log_func_copy,&ev);
	g_assert(validate_CORBA_Environment(&ev));
	CORBA_exception_free(&ev);

	impl_Captive_Vfs_init_g_log_func_handled=FALSE;
}
