/* $Id: split.h,v 1.10 2003/11/04 18:17:25 short Exp $
 * Include file for CORBA/ORBit split-mode initializer
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _SERVER_SPLIT_H
#define _SERVER_SPLIT_H 1


#include <glib/gmacros.h>
#include <glib/gmain.h>
#ifdef ORBIT2	/* Prevent missing $(ORBIT_CFLAGS) outside of libcaptive/sandbox/ */
#include "sandbox.h"
#include "captive/client-vfs.h"
#include "../client/vfs-parent.h"
#endif


G_BEGIN_DECLS

#ifdef ORBIT2	/* Prevent missing $(ORBIT_CFLAGS) outside of libcaptive/sandbox/ */
extern CORBA_Environment captive_corba_ev;
extern CORBA_ORB captive_corba_orb;
extern PortableServer_POA captive_corba_poa;
#endif

void captive_corba_sandbox_child(const gchar *chrooted_orbit_dir);
void sandbox_child_prepare_shutdown(void);
void captive_sandbox_fd_closeup(int fd_first_to_delete);
void sandbox_child_shutdown(void);
GMainLoop *captive_corba_get_loop(void);
GMainContext *captive_corba_get_context(void);
#ifdef ORBIT2	/* Prevent missing $(ORBIT_CFLAGS) outside of libcaptive/sandbox/ */
gboolean captive_sandbox_spawn(CaptiveVfsParentObject *captive_vfs_parent_object);
gboolean validate_CORBA_Environment(CORBA_Environment *evp);
GnomeVFSResult captive_sandbox_parent_return_from_CORBA_Environment
		(CORBA_Environment *evp,CaptiveVfsParentObject *captive_vfs_parent_object);
void captive_sandbox_child_GnomeVFSResultException_throw(CORBA_Environment *evp,GnomeVFSResult errvfsresult);
#endif

G_END_DECLS


#endif /* _SERVER_SPLIT_H */
