/* $Id: audit.c,v 1.2 2005/12/25 06:20:59 lace Exp $
 * reactos security auditing emulation of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/sefuncs.h"	/* self */
#include <glib/gmessages.h>


/**
 * SeAuditingFileEvents:
 * @AccessGranted: Attempt was already done? Unclear.
 * @SecurityDescriptor: Unknown.
 *
 * Returns: %TRUE if auditing of all the files is requested.
 */
BOOLEAN SeAuditingFileEvents(IN BOOLEAN AccessGranted,IN PSECURITY_DESCRIPTOR SecurityDescriptor)
{
	g_return_val_if_fail(SecurityDescriptor!=NULL,FALSE);

	return FALSE;	/* no auditing is being performed */
}


/**
 * SeAuditingFileEventsWithContext:
 * @AccessGranted: Attempt was already done? Unclear.
 * @SecurityDescriptor: Unknown.
 * @SubjectSecurityContext: Unknown.
 *
 * Returns: %TRUE if auditing of all the files is requested. FIXME: Not sure.
 */
BOOLEAN SeAuditingFileEventsWithContext(IN BOOLEAN AccessGranted,IN PSECURITY_DESCRIPTOR SecurityDescriptor,
		IN PSECURITY_SUBJECT_CONTEXT SubjectSecurityContext OPTIONAL)
{
	g_return_val_if_fail(SecurityDescriptor!=NULL,FALSE);
	g_return_val_if_fail(SubjectSecurityContext!=NULL,FALSE);

	return FALSE;	/* no auditing is being performed */
}
