/* $Id: priv.c,v 1.1 2003/03/28 20:25:43 short Exp $
 * reactos security privileges emulation of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/sefuncs.h"	/* self */
#include <glib/gmessages.h>


/**
 * SePrivilegeCheck:
 * @Privileges: List of the requested privileges; Policy 'all' or 'any' is specified inside.
 * %NULL value is forbidden.
 * @SubjectContext: #PSECURITY_SUBJECT_CONTEXT of the owner to check the security for.
 * %NULL value is forbidden.
 * @PreviousMode: %UserMode or %KernelMode to check the security for.
 *
 * Check the set of privileges @Privileges for @SubjectContext and return if they
 * are sufficient.
 *
 * libcaptive does not support any security and therefore it always returns %TRUE.
 *
 * Returns: %TRUE if the privileges are sufficient.
 */
BOOLEAN SePrivilegeCheck(PPRIVILEGE_SET Privileges,PSECURITY_SUBJECT_CONTEXT SubjectContext,KPROCESSOR_MODE PreviousMode)
{
	g_return_val_if_fail(Privileges!=NULL,FALSE);	/* means privileges not sufficient */
	g_return_val_if_fail(SubjectContext!=NULL,FALSE);	/* means privileges not sufficient */

	return TRUE;	/* privileges OK */
}
