/* $Id: sd.c,v 1.1 2003/03/24 00:14:01 short Exp $
 * reactos SECURITY_DESCRIPTOR functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/sefuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ntos/rtl.h"	/* for RtlLengthSecurityDescriptor() */


/**
 * SeValidSecurityDescriptor:
 * @Length: Available size for @SecurityDescriptor.
 * @SecurityDescriptor: #SECURITY_DESCRIPTOR to check the size of.
 *
 * Functions checks whether @SecurityDescriptor fits to the are size @Length.
 * RtlLengthSecurityDescriptor(@SecurityDescriptor) must be less or equal
 * @Length to succeed.
 *
 * Returns: %TRUE if @SecurityDescriptor fits there.
 */
BOOLEAN SeValidSecurityDescriptor(IN ULONG Length,IN PSECURITY_DESCRIPTOR SecurityDescriptor)
{
ULONG reallen;

	g_return_val_if_fail(SecurityDescriptor!=NULL,FALSE);

	reallen=RtlLengthSecurityDescriptor(SecurityDescriptor);

	/* Sanity check only:
	 * It may happen but it should IMO mean something rotten
	 */
	g_assert(reallen<=Length);

	return (reallen<=Length);
}
