/* $Id: cdrom.c,v 1.16 2003/05/04 12:03:33 short Exp $
 * "\Device\CdRom%d" storage emulation driver for reactos of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/storage.h"	/* self */
#include "media.h"
#include <glib/gmessages.h>
#include "captive/unicode.h"
#include "reactos/ddk/status.h"	/* for NT_SUCCESS() */
#include "captive/options.h"


/**
 * captive_cdrom_init:
 *
 * Creates system device "\Device\CdRom%d" providing readonly access
 * to the given #captive_image_iochannel as emulation of CD-ROM driver.
 *
 * libcaptive currently supports just one drive and thus "\Device\CdRom0"
 * is always created. It is forbidden to call this function twice.
 *
 * Returns: %TRUE if the initialization was successful.
 */
gboolean captive_cdrom_init(void)
{
static struct captive_DriverObject cdrom_captive_DriverObject;
NTSTATUS err;

	g_return_val_if_fail(captive_image_iochannel!=NULL,FALSE);

	cdrom_captive_DriverObject.DiskGeometry.BytesPerSector=2048;
	cdrom_captive_DriverObject.DiskGeometry.MediaType=RemovableMedia;
	cdrom_captive_DriverObject.DeviceName_utf8="\\Device\\CdRom0";
	cdrom_captive_DriverObject.DeviceType=FILE_DEVICE_CD_ROM;
	cdrom_captive_DriverObject.DeviceCharacteristics=FILE_REMOVABLE_MEDIA|FILE_READ_ONLY_DEVICE;
	err=captive_media_DriverEntry(
			&cdrom_captive_DriverObject,	/* DriverEntry_DriverObject */
			captive_utf8_to_UnicodeString_alloca("\\captive\\storage\\cdrom"));	/* DriverEntry_RegistryPath; ignored */
	g_return_val_if_fail(NT_SUCCESS(err),FALSE);

	return TRUE;
}
