/* $Id: disk.c,v 1.3 2003/05/04 12:03:33 short Exp $
 * "\Device\CaptiveHarddisk%d" storage emulation driver for reactos of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/storage.h"	/* self */
#include "media.h"
#include <glib/gmessages.h>
#include "captive/unicode.h"
#include "reactos/ddk/status.h"	/* for NT_SUCCESS() */
#include "captive/options.h"


/**
 * captive_disk_init:
 *
 * Creates system device "\Device\CaptiveHarddisk%d" providing readwrite access
 * to the given #captive_image_iochannel as emulation of harddisk driver.
 * reactos initializes "\Device\Harddisk%d\Partition0" as the whole disk
 * and each partition it founds by IoReadPartitionTable() it will create
 * as "\Device\Harddisk%d\Partition1", "\Device\Harddisk%d\Partition2" etc.
 *
 * libcaptive does not (yet?) support any partitions and it will always create
 * just the disk device for the whole given #captive_image_iochannel.
 * As this behaviour is a bit specific we rather create some non-standard name
 * of the device; anyway I have seen some "\Device\Harddisk%dVolume%d" on W32
 * system.
 *
 * captive currently supports just one drive and thus "\Device\CaptiveHarddisk0"
 * is always created. It is forbidden to call this function twice.
 *
 * Returns: %TRUE if the initialization was successful.
 */
gboolean captive_disk_init(void)
{
static struct captive_DriverObject disk_captive_DriverObject;
NTSTATUS err;

	g_return_val_if_fail(captive_image_iochannel!=NULL,FALSE);

	disk_captive_DriverObject.DiskGeometry.BytesPerSector=512;
	disk_captive_DriverObject.DiskGeometry.MediaType=FixedMedia;
	disk_captive_DriverObject.DeviceName_utf8="\\Device\\CaptiveHarddisk0";
	disk_captive_DriverObject.DeviceType=FILE_DEVICE_DISK;
	disk_captive_DriverObject.DeviceCharacteristics=0;	/* !FILE_REMOVABLE_MEDIA && !FILE_READ_ONLY_DEVICE */
	err=captive_media_DriverEntry(
			&disk_captive_DriverObject,	/* DriverEntry_DriverObject */
			captive_utf8_to_UnicodeString_alloca("\\captive\\storage\\disk"));	/* DriverEntry_RegistryPath; ignored */
	g_return_val_if_fail(NT_SUCCESS(err),FALSE);

	return TRUE;
}
