/* $Id: iounixchannel.c,v 1.2 2003/12/06 23:17:26 short Exp $
 * Detect file descriptor of a given GIOUnixChannel for libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "iounixchannel.h"	/* self */
#include <glib/gmessages.h>
#include <glib/giochannel.h>
#include <glib/gtypes.h>
#include <unistd.h>
#include <fcntl.h>


static GIOChannel *iochannel_null;

int captive_iounixchannel_get_fd(GIOChannel *iochannel)
{
int r;

	g_return_val_if_fail(iochannel!=NULL,-1);

	if (!iochannel_null) {
int fd;

		fd=open("/dev/null",O_RDONLY);
		/* We may be already chroot()ed.
		 * We would be called from captive_storage_relastblock()
		 * and it is safe to return -1 in such case.
		 */
		if (fd==-1)
			return -1;
		iochannel_null=g_io_channel_unix_new(fd);
		g_return_val_if_fail(iochannel_null!=NULL,-1);
		}

	if (iochannel->funcs!=iochannel_null->funcs) {
		/* Not a UNIX file descriptor */
		return -1;
		}

	/* It is forbidden to callg_io_channel_unix_get_fd()
	 * if you are not sure it is a 'GIOUnixChannel'.
	 */
	r=g_io_channel_unix_get_fd(iochannel);
	g_return_val_if_fail(r!=-1,-1);

	return r;
}
