/* $Id: media.h,v 1.3 2003/12/06 14:04:54 short Exp $
 * Include file for captive media (cdrom/disk) emulation for reactos
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_STORAGE_MEDIA_H
#define _CAPTIVE_STORAGE_MEDIA_H 1


#include <glib/gmacros.h>
#include "reactos/ddk/iotypes.h"	/* for DRIVER_OBJECT */
#include "reactos/ddk/ntddscsi.h"	/* for IO_SCSI_CAPABILITIES */


G_BEGIN_DECLS

struct captive_DriverObject {
	DRIVER_OBJECT DriverObject;	/* keep first! */

	DISK_GEOMETRY DiskGeometry;
	DISK_GEOMETRY DiskGeometry_check;	/* for g_assert() checking against foreign modifications */
	IO_SCSI_CAPABILITIES PortCapabilities;
	IO_SCSI_CAPABILITIES PortCapabilities_check;	/* for g_assert() checking against foreign modifications */

	/* expect: */
	const gchar *DeviceName_utf8;
	DEVICE_TYPE DeviceType;
	ULONG DeviceCharacteristics;
	};


NTSTATUS captive_media_DriverEntry(struct captive_DriverObject *captive_DriverObject,PUNICODE_STRING RegistryPath);

G_END_DECLS


#endif /* _CAPTIVE_STORAGE_MEDIA_H */
