#! /bin/sh
# $Id: ext2fsd.so-build.sh,v 1.1 2003/09/14 07:35:03 short Exp $
# Compile Ext2fsd by GCC in UNIX system as symbol-featured debuggable .so
# Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; exactly version 2 of June 1991 is required
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


(
	# Microsoft Windows XP DDK include files directory:
	INC=$HOME/.w32-inc/
	TARGET=./ext2fsd.so

	set -ex
	rm -f _all.c
	c=`echo *.c`
	# Force <ntifs.h> to by considered system header file:
	echo '#include <ntifs.h>' >>_all.c
	echo '#define InterlockedDecrement(Addend) (InterlockedExchangeAdd((Addend),-1)-1)' >>_all.c
	echo '#define InterlockedExchangeAdd(Addend,Incr) ({ LONG _IEA_r=*(Addend); *(Addend)+=(Incr); _IEA_r; })' >>_all.c
	for i in $c;do
		echo '#include "'"$i"'"' >>_all.c
		done
	touch pshpack1.h poppack.h pshpack4.h
	gcc -shared -o"$TARGET" -ggdb3 -Wall -fshort-wchar \
			-DDBG -D_MSC_VER=1300 -D_MSC_FULL_VER=13009038 -D_WIN32 -D_NTSYSTEM_ \
			-D__cdecl="" -D__stdcall="" -D__fastcall="" -D_fastcall="" \
			-D__int64="long long" -D_W64="" -D_M_IX86 -D_X86_ \
			-D'__declspec(x)'="" -D__forceinline="" -D__noop="" \
			-D__try="" -D"__finally"="label_finally:" \
			-D'__except(x)'="if (0)" -D"__leave"="goto label_finally" \
			-D_INTEGRAL_MAX_BITS=64 -D_WIN32_WINNT=0x0501 \
			-D__int8="char" -D__int16="short" -D__int32="int" \
			`for i in . $INC/{crt,ddk/wxp,wxp};do echo -isystem $i;done` \
			_all.c
	#rm -f _all.c
	echo ok
	) 2>&1 |grep -v ' warning: \| In function \|At top level:' #|less
